@echo off
cls
echo.
echo Demonstration of ISO Architectural Forms
echo as used by XML Mortgage Partners (XML-MP)
echo.
echo.

echo First let's look at a simplified mortgage
echo industry message:

echo [type my-message.xml]
echo.
type my-message.xml
echo.
echo Let's look at the DTD for the above message:
pause
echo.

echo Here is the DTD for the above message:
echo [type mymortmess.dtd]
echo.
type mymortmess.dtd
echo.
pause
echo As you can see, there is a processing
echo instruction that invokes ISO/IEC 10744:1997
echo (International Standard 10744).  It
echo declares that messages that conform to
echo this DTD may inherit element types from
echo the XML-MP (XML Mortgage Partners) DTD.
echo.
echo This little processing instruction does
echo a remarkable thing: it makes it possible
echo for an XML parser to "extract" and 
echo validate an otherwise-implicit instance
echo of the XML-MP DTD from the above message,
echo without a transformation specification,
echo and without a special program to make the
echo transformation.  The transformation is
echo entirely implicit in the inheritance
echo declared in the DTD by means of the
echo IS10744 processing instruction.

echo.
pause

echo But before we extract that implicit
echo instance, let's show the result of parsing
echo the message and then reconstituting it
echo again as XML:
echo [sx -c xml.soc my-message.xml]
echo.
pause
..\sx -c xml.soc my-message.xml
echo.

echo You can see that this is the same message,
echo except that some nonsignificant whitespace
echo has disappeared.  It's not obvious that
echo there are in fact several implicit 
echo messages in this single message, is it?
echo So let's see one of them.  We'll extract
echo the whole XML-MP message first:
echo [sx -c xml.soc -A XMLMP-MESSAGE my-message.xml]

echo.
pause
echo.
..\sx -c xml.soc -A XMLMP-MESSAGE my-message.xml
echo.

echo The MY-XMLMP-MESSAGE element became an
echo XMLMP-MESSAGE element, and the
echo MY-APPRAISAL element became an APPRAISAL
echo element.  This message conforms to the
echo mortgage-industry-wide XML-MP DTD, and it
echo has been validated against that DTD.
echo.
echo Let's look at that DTD.
echo [type xmlmp-message.dtd]
echo.
pause
type xmlmp-message.dtd
echo.
pause

echo As you can see, ISO architectural forms
echo make it possible for all of the players in
echo the industry to have local control over
echo their own DTDs, even
echo if those DTDs rename element types, add
echo new element types, add attributes, add
echo elements to content models, etc. etc.,
echo without compromising the
echo interchangeability or the validatability
echo of our industrial messages.  If an 
echo implicit message does not conform to the
echo corresponding inherited DTD, anyone can
echo determine whose software caused the error,
echo because anyone can detect the error using
echo ISO-standard-conforming XML parsing software.
echo.

echo We're using ISO architectural forms for
echo another purpose, too: they allow us to
echo inherit many smaller DTDs in our master
echo mortgage message DTD.  

echo This lets us allow several committees to
echo work separately on their parts of the DTD,
echo while guaranteeing a smooth integration of
echo all the parts, and easy maintenance of the
echo whole, even while the parts are evolving.
echo It also lets business partners extract
echo only the parts of any given message that
echo are relevant to their businesses.

echo With ISO architectural forms, inheritance
echo can be both multiple and recursive.  In
echo this demo, the XML-MP master message DTD
echo inherits from a much smaller DTD that is
echo just for appraisal information.  To
echo demonstrate this, we'll extract just the
echo appraisal instance from our same message
echo as before:
echo [sx -c xml.soc -A XMLMP-MESSAGE 
echo  -A XMLMP-APPRAISAL my-message.xml]

echo.
pause
echo.
..\sx -c xml.soc -A XMLMP-MESSAGE -A XMLMP-APPRAISAL my-message.xml
echo.

echo In the above instance, we don't see the
echo securitization section, because
echo securitization doesn't appear in the
echo appraisal DTD.  This kind of message
echo filtering might be used by a business 
echo that is not interested in securitization,
echo but is interested in appraisals.
echo.
echo.
echo - 30 -
echo.